<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class SlugGatewayController extends Controller
{
    /**
     * Resolve /contacts/{slug} → original /contacts/... URL
     */
    public function resolveContacts(Request $request, string $slug)
    {
        // Single-use: change pull() to get() for reusable slugs
        $mapped = Cache::pull("slug_map_contacts:{$slug}");
        if (!$mapped) {
            abort(404);
        }

        // Preserve query string, then internally dispatch to the original URL
        $target = $mapped;
        if ($qs = $request->getQueryString()) {
            $target .= (str_contains($mapped, '?') ? '&' : '?') . $qs;
        }

        $sub = Request::create(
            $target,
            'GET',
            [],
            $request->cookies->all(),
            [],
            $request->server->all()
        );
        $sub->setLaravelSession($request->getSession());

        return app()->handle($sub);
    }

    // (Keep your existing login slug resolver here if you have one)
}
